import module namespace bytecrafts = "http://www.bytecrafts.com" at "/db/cybar/queries/uuid.xql";


declare namespace exist = "http://exist.sourceforge.net/NS/exist";
declare namespace request = "http://exist-db.org/xquery/request";
declare option exist:serialize "method=xml media-type=text/xml";

declare variable $edit as document-node()* := collection('/db/cybar/edit');
declare variable $legislation as document-node()* := collection('/db/cybar/legislation');
declare variable $collection as xs:string := request:get-parameter('collection','');
declare variable $element as xs:string := request:get-parameter('element','');

if ($collection = "edit" and $element = "enum") then 
    for $footnote in $edit//footnote return
        if (fn:not(fn:exists($footnote/enum))) then
            update insert <enum id="en{bytecrafts:generate-uuid-v4()}"></enum> preceding $footnote/text
        else()
else if ($collection = "edit" and $element = "header") then
    for $footnote in $edit//footnote return
        if (fn:not(fn:exists($footnote/header))) then
            update insert <header id="hr{bytecrafts:generate-uuid-v4()}"></header> preceding $footnote/text
        else()
else if ($collection = "edit" and $element = "category") then
    for $footnote in $edit//footnote return
         update insert attribute {'category'} {''} into $footnote
else if ($collection = "legislation" and $element = "enum") then
    for $footnote in $legislation//footnote return
        if (fn:not(fn:exists($footnote/enum))) then
            update insert <enum id="en{bytecrafts:generate-uuid-v4()}"></enum> preceding $footnote/text
        else()
else if ($collection = "legislation" and $element = "header") then
    for $footnote in $legislation//footnote return
        if (fn:not(fn:exists($footnote/header))) then
            update insert <header id="hr{bytecrafts:generate-uuid-v4()}"></header> preceding $footnote/text
        else()
else if ($collection = "legislation" and $element = "category") then
    for $footnote in $legislation//footnote return
        update insert attribute {'category'} {''} into $footnote
else()