import module namespace bytecrafts = "http://www.bytecrafts.com" at "uuid.xql";

declare namespace exist = "http://exist.sourceforge.net/NS/exist";
declare namespace request = "http://exist-db.org/xquery/request";
declare option exist:serialize "method=xml media-type=text/xml";

declare variable $legislation as document-node()* := collection('/db/cybar/edit');
declare variable $uuid as xs:string := request:get-parameter('uuid','');
declare variable $parent_id as xs:string := request:get-parameter('parent','');
declare variable $after as xs:string := request:get-parameter('after','');
declare variable $before as xs:string := request:get-parameter('before','');
declare variable $position_element as xs:string := request:get-parameter('position_element','');
declare variable $amending_instrument as xs:string := request:get-parameter('amending_instrument','');
declare variable $enforce_date as xs:string :=request:get-parameter('enforce_date','');


(: Adding a sub-division after another element :)
if ($after != "" and $before = "") then
        (: Adding a sub-division after a section :)
        if ($position_element = "section") then 
            update insert <sub-division id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header></sub-division> following $legislation//division[@id=$parent_id]//section[@id=$after]
        (: Adding a sub-division after another sub-division :)
        else if ($position_element = "sub-division") then
            update insert <sub-division id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header></sub-division> following $legislation//division[@id=$parent_id]//sub-division[@id=$after]
        else()
(: Adding a sub-division before another element :)
else if ($after = "" and $before != "") then
        (: Adding a sub-division before a section :)
        if ($position_element = "section")  then
            update insert <sub-division id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header></sub-division> preceding $legislation//division[@id=$parent_id]//section[@id=$before]
        (: Adding a sub-division before another sub-division :)
        else if ($position_element = "sub-division") then
            update insert <sub-division id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header></sub-division> preceding $legislation//division[@id=$parent_id]//sub-division[@id=$before]
        else()
(: Adding a sub-division as the last element of a division :)
else if ($after = "" and $before = "") then
         update insert <sub-division id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header></sub-division> into $legislation//division[@id=$parent_id]
else ()