import module namespace bytecrafts = "http://www.bytecrafts.com" at "/db/cybar/queries/uuid.xql";

declare namespace exist = "http://exist.sourceforge.net/NS/exist";
declare namespace request = "http://exist-db.org/xquery/request";
declare option exist:serialize "method=xml media-type=text/xml";

declare variable $instruments as xs:string := request:get-parameter('instruments','');
declare variable $sections as xs:string := request:get-parameter('sections','');
declare variable $appendixes as xs:string := request:get-parameter('appendixes','');
declare variable $footnotes as xs:string := request:get-parameter('footnotes','');

element legislation {
    attribute id { fn:concat('ll',bytecrafts:generate-uuid-v4())},
    attribute lang {"EL"},
    attribute law-enforce-date {""},
    element form {
        element legis-type {"Ενοποιημένη Νομοθεσία"},
        element legis-num {
            attribute id {fn:concat('ln',bytecrafts:generate-uuid-v4())},
            attribute current {"yes"}
        },
        element official-title {
            attribute id {fn:concat('ot',bytecrafts:generate-uuid-v4())},
            attribute current {"yes"}
        },
        element short-title {
            attribute id {fn:concat('st',bytecrafts:generate-uuid-v4())},
            attribute current {"yes"}
        },
        element amending-instruments {
            for $i in (1 to xs:integer($instruments))
                return element instrument {
                  attribute id {fn:concat('ai',bytecrafts:generate-uuid-v4())}
                }  
        }
    }, 
    element legis-body {
        element preamble {
            attribute id {fn:concat('pr',bytecrafts:generate-uuid-v4())},
            attribute current {"yes"}
        },
        for $i in (1 to xs:integer($sections))
            return element section {
                attribute id {fn:concat('sc',bytecrafts:generate-uuid-v4())},
                attribute current {"yes"},
                element enum {
                    attribute id {fn:concat('en',bytecrafts:generate-uuid-v4())},
                    attribute current {"yes"},
                    $i
                },
                element header {
                    attribute id {fn:concat('hr',bytecrafts:generate-uuid-v4())},
                    attribute current {"yes"},
                    $i
                },
                element text {
                    attribute id {fn:concat('tx',bytecrafts:generate-uuid-v4())},
                    attribute current {"yes"}
                }
            },   
        for $i in (1 to xs:integer($appendixes)-1)
            return element appendix {
                attribute id {fn:concat('ap',bytecrafts:generate-uuid-v4())},
                attribute current {"yes"},
                element enum {
                    attribute id {fn:concat('en',bytecrafts:generate-uuid-v4())},
                    attribute current {"yes"}
                },
                element text {
                    attribute id {fn:concat('tx',bytecrafts:generate-uuid-v4())},
                    attribute current {"yes"}
                }
            },
            element appendix {
                attribute id {fn:concat('ap',bytecrafts:generate-uuid-v4())},
                attribute current {"yes"},
                element enum {
                    attribute id {fn:concat('en',bytecrafts:generate-uuid-v4())},
                    attribute current {"yes"}
                },
                element text {
                    attribute id {fn:concat('tx',bytecrafts:generate-uuid-v4())},
                    attribute current {"yes"}
                }
            }   
    },
    for $i in (1 to xs:integer($footnotes))
        return element footnote {
                attribute id {fn:concat('ft',bytecrafts:generate-uuid-v4())},
                attribute current {"yes"},
                attribute category {""},
                element enum {
                    attribute id {fn:concat('en',bytecrafts:generate-uuid-v4())},
                    attribute current {"yes"}
                },
                element header {
                    attribute id {fn:concat('hr',bytecrafts:generate-uuid-v4())},
                    attribute current {"yes"}
                },
                element text {
                    attribute id {fn:concat('tx',bytecrafts:generate-uuid-v4())},
                    attribute current {"yes"}
                }
            }   
}