import module namespace functx = "http://www.functx.com" at "functx.xql";

declare namespace exist = "http://exist.sourceforge.net/NS/exist";
declare namespace request = "http://exist-db.org/xquery/request";
declare option exist:serialize "method=xml media-type=text/xml";

declare variable $uuid as xs:string := request:get-parameter('uuid','');
declare variable $amend_uuid as xs:string := request:get-parameter('amend_uuid','');
declare variable $amending_instrument as xs:string := request:get-parameter('amending_instrument','');
declare variable $enforce_date as xs:string :=request:get-parameter('enforce_date','');
declare variable $legislation as document-node()* := collection("/db/cybar/edit");
declare variable $stage as xs:string := request:get-parameter('stage','');
declare variable $repealed := functx:add-or-update-attributes($legislation//division[@id=$amend_uuid],(xs:QName ('id'), xs:QName('instrument-id'),xs:QName('amended-id'),xs:QName('instrument-type'),xs:QName('enforced-date'),xs:QName('dirty')),($uuid,$amending_instrument,$amend_uuid,'repeal',$enforce_date,'yes'));

if ($stage = '1') then
    update insert $repealed preceding $legislation//division[@id=$amend_uuid]
else if ($stage = '2') then
    update replace $legislation//division[@id=$amend_uuid]/@current with "no"
else()