declare namespace exist = "http://exist.sourceforge.net/NS/exist";
declare namespace request = "http://exist-db.org/xquery/request";
declare option exist:serialize "method=xml media-type=text/xml";

declare variable $term as xs:string := request:get-parameter('term','');
declare variable $type as xs:string := request:get-parameter('type','');
declare variable $legislation as document-node()* := collection("/db/cybar/legislation");


if ($type = 'title') then
    element results {
        for $hit in $legislation//short-title[ft:query(., $term)] return
            element result{
                attribute id {$hit/../../@id},
                element short-title {$hit/../short-title/text()},
                element legis-num {$hit/../legis-num/text()}
            }
    }
else if ($type = 'number') then
    element results {
        for $hit in $legislation//legis-num[ft:query(., $term)] return
            element result{
                attribute id {$hit/../../@id},
                element short-title {$hit/../short-title/text()},
                element legis-num {$hit/../legis-num/text()}
            }
    }
else()    