module namespace bytecrafts = "http://www.bytecrafts.com";

import module namespace util = "http://exist-db.org/xquery/util";

declare function bytecrafts:random-hex($length as xs:integer) as xs:string 
{
    string-join(
        for $n in 1 to $length
        return bytecrafts:integer-to-hex(util:random(15)),""
    )
};

declare function bytecrafts:generate-uuid-v4() as xs:string {
    string-join(
        (bytecrafts:random-hex(8),bytecrafts:random-hex(4),bytecrafts:random-hex(4),bytecrafts:random-hex(4),bytecrafts:random-hex(12)),"-"
    )
};

declare function bytecrafts:integer-to-hex($in as xs:integer) as xs:string {

if ($in eq 0) then 
    '0' 
else   
    fn:concat(if ($in gt 16) then bytecrafts:integer-to-hex($in idiv 16) else '', substring('0123456789abcdef', ($in mod 16) +1, 1))
};