declare namespace exist = "http://exist.sourceforge.net/NS/exist";
declare namespace request = "http://exist-db.org/xquery/request";
declare option exist:serialize "method=xml media-type=text/xml";

declare variable $legislation as document-node()* := collection('/db/cybar/edit');
declare variable $uuid as xs:string := request:get-parameter('uuid','');
declare variable $legis_id as xs:string := request:get-parameter('legislation_uuid','');
declare variable $before as xs:string := request:get-parameter('before','');
declare variable $after as xs:string := request:get-parameter('after','');
declare variable $position_element as xs:string := request:get-parameter('position_element','');
declare variable $stage as xs:string := request:get-parameter('stage','');
declare variable $uuidadded := fn:concat("added",$uuid);

declare function local:get-instrument() as xs:string 
{
    let $return := $legislation//instrument[@id=$uuid]/text()
    return $return
};

(: Moving an intrument after another element :)
if ($after != "" and $before = "" and $stage='1') then
       update insert <instrument id="added{$uuid}">{local:get-instrument()}</instrument> following $legislation//instrument[@id=$after]
(: Moving a sub-division before another element :)
else if ($after = "" and $before != "" and $stage='1') then
       update insert <instrument id="added{$uuid}">{local:get-instrument()}</instrument> preceding $legislation//instrument[@id=$before]
(: Moving a sub-division as the last element of a division :)
else if ($after = "" and $before = "" and $stage='1') then
       update insert <instrument id="added{$uuid}">{local:get-instrument()}</instrument> into $legislation[@id=$legis_id]//amending-instruments

else if ($after = "" and $before = "" and $stage = '2') then
        update delete $legislation//instrument[@id=$uuid]
else if ($after = "" and $before = "" and $stage = '3') then
        update value $legislation//instrument[@id=$uuidadded]/@id with $uuid
else()