import module namespace functx = "http://www.functx.com" at "functx.xql";

declare namespace exist = "http://exist.sourceforge.net/NS/exist";
declare namespace request = "http://exist-db.org/xquery/request";
declare option exist:serialize "method=xml media-type=text/xml";

declare variable $legislation as document-node()* := collection('/db/cybar/edit');
declare variable $uuid as xs:string := request:get-parameter('uuid','');
declare variable $before as xs:string := request:get-parameter('before','');
declare variable $after as xs:string := request:get-parameter('after','');
declare variable $position-element as xs:string := request:get-parameter('position','');
declare variable $stage as xs:string := request:get-parameter('stage','');
declare variable $uuidadded := functx:add-or-update-attributes($legislation//division[@id=$uuid],xs:QName('id'),'added');

(: Moving an intrument after another element :)
if ($after != "" and $before = "" and $stage='1') then
    if ($position-element = "section") then
       update insert $uuidadded following $legislation//section[@id=$after]
    else if ($position-element = "division") then
        update insert $uuidadded following $legislation//division[@id=$after]
    else if ($position-element = "preamble") then
        update insert $uuidadded following $legislation//preamble[@id=$after]
    else()    
else if ($after = "" and $before != "" and $stage='1') then
    if ($position-element = "section") then
        update insert $uuidadded preceding $legislation//section[@id=$before]
    else if ($position-element = "division") then
        update insert $uuidadded preceding $legislation/division[@id=$before]
    else if ($position-element = "appendix") then
        update insert $uuidadded preceding $legislation/appendix[@id=$before]
    else()
else if ($after = "" and $before = "" and $stage = '2') then
        update delete $legislation//division[@id=$uuid]
else if ($after = "" and $before = "" and $stage = '3') then
        update value $legislation//division[@id="added"]/@id with $uuid
else()