declare namespace exist = "http://exist.sourceforge.net/NS/exist";
declare namespace request = "http://exist-db.org/xquery/request";
declare option exist:serialize "method=xml media-type=text/xml";

declare variable $source as xs:string := request:get-parameter('source','');
declare variable $id as xs:string := request:get-parameter('uuid','');
declare variable $user as xs:string := request:get-parameter('user','');
declare variable $legislationapproval as document-node()* := collection('/db/cybar/edit/approval');
declare variable $legislationdraft as document-node()* := collection(fn:concat('/db/cybar/edit/draft/',$user));
declare variable $legislation as document-node()* := collection('/db/cybar/legislation');

<results> {
if ($source = 'approval') then
for $result in $legislationapproval//legislation[@id=$id]//instrument return 
    $result
else if ($source = 'drafts') then
for $result in $legislationdraft//legislation[@id=$id]//instrument return 
    $result
else if ($source = 'legislation') then
for $result in $legislation//legislation[@id=$id]//instrument return 
    $result
else()
}
</results>