declare namespace exist = "http://exist.sourceforge.net/NS/exist";
declare namespace request = "http://exist-db.org/xquery/request";
declare option exist:serialize "method=xml media-type=text/xml";

declare variable $amend_uuid as xs:string := request:get-parameter('amend_uuid','');
declare variable $amending_instrument as xs:string := request:get-parameter('amending_instrument','');
declare variable $enforce_date as xs:string := request:get-parameter('enforce_date','');
declare variable $uuid as xs:string := request:get-parameter('uuid','');
declare variable $expire_date as xs:string := request:get-parameter('expire_date','');
declare variable $legislation as document-node()* := collection("/db/cybar/edit");
declare variable $stage as xs:string := request:get-parameter('stage','');

declare function local:get_legis_num() as xs:string
{
    let $return := $legislation//legis-num[@id=$amend_uuid]/text()
    return $return
};

if ($stage = '1') then
    update replace $legislation//legis-num[@id=$amend_uuid]/@current with "no"
else if ($stage = '2') then
    if ($expire_date = '') then
        update insert <legis-num id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" amended-id="{$amend_uuid}" instrument-type="substitution" enforced-date="{$enforce_date}" dirty="yes">{local:get_legis_num()}</legis-num> preceding $legislation//legis-num[@id=$amend_uuid]
    else if ($expire_date != '') then
        update insert <legis-num id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" amended-id="{$amend_uuid}" instrument-type="substitution" enforced-date="{$enforce_date}" expired-date="{$expire_date}" dirty="yes">{local:get_legis_num()}</legis-num> preceding $legislation//legis-num[@id=$amend_uuid]
    else()
else()