import module namespace bytecrafts = "http://www.bytecrafts.com" at "uuid.xql";

declare namespace exist = "http://exist.sourceforge.net/NS/exist";
declare namespace request = "http://exist-db.org/xquery/request";
declare option exist:serialize "method=xml media-type=text/xml";

declare variable $legislation as document-node()* := collection('/db/cybar/edit');
declare variable $uuid as xs:string := request:get-parameter('uuid','');
declare variable $legis_id as xs:string := request:get-parameter('legislation','');
declare variable $amending_instrument as xs:string := request:get-parameter('amending_instrument','');
declare variable $enforce_date as xs:string :=request:get-parameter('enforce_date','');
declare variable $before as xs:string := request:get-parameter('before','');
declare variable $position_element as xs:string := request:get-parameter('position_element','');

if ($position_element = "section")  then
    update insert <preamble id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"></preamble> preceding $legislation//section[@id=$before]
else if ($position_element = "division") then
    update insert <preamble id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"></preamble> preceding $legislation//division[@id=$before]
else()