import module namespace bytecrafts = "http://www.bytecrafts.com" at "uuid.xql";

declare namespace exist = "http://exist.sourceforge.net/NS/exist";
declare namespace request = "http://exist-db.org/xquery/request";
declare option exist:serialize "method=xml media-type=text/xml";

declare variable $legislation as document-node()* := collection('/db/cybar/edit');
declare variable $uuid as xs:string := request:get-parameter('uuid','');
declare variable $legis_id as xs:string := request:get-parameter('legislation','');
declare variable $after as xs:string := request:get-parameter('after','');
declare variable $before as xs:string := request:get-parameter('before','');
declare variable $position_element as xs:string := request:get-parameter('position_element','');
declare variable $amending_instrument as xs:string := request:get-parameter('amending_instrument','');
declare variable $enforce_date as xs:string :=request:get-parameter('enforce_date','');

(: Adding a division after another element :)
response:set-header("Access-Control-Allow-Origin","*"),
if ($after != "" and $before = "") then
        (: Adding a division after a section :)
        if ($position_element = "section") then 
            update insert <division id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header></division> following $legislation//legislation[@id=$legis_id]//legis-body/section[@id=$after]
        (: Adding a division after another division :)
        else if ($position_element = "division") then
            update insert <division id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header></division> following $legislation//legislation[@id=$legis_id]//legis-body/division[@id=$after]
        else()
(: Adding a division before another element :)
else if ($after = "" and $before != "") then
        (: Adding a division before a section :)
        if ($position_element = "section")  then
            update insert <division id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header></division> preceding $legislation//legislation[@id=$legis_id]//legis-body/section[@id=$before]
        (: Adding a division before another division :)
        else if ($position_element = "division") then
            update insert <division id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header></division> preceding $legislation//legislation[@id=$legis_id]//legis-body/division[@id=$before]     
        else if ($position_element = "appendix") then
            update insert <division id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header></division> preceding $legislation//legislation[@id=$legis_id]//legis-body/appendix[@id=$before]    
        else()
(: Adding a section as the last element of a division :)
else if ($after = "" and $before = "") then
         update insert <division id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header></division> into $legislation//legislation[@id=$legis_id]/legis-body
else ()