import module namespace bytecrafts = "http://www.bytecrafts.com" at "uuid.xql";

declare namespace exist = "http://exist.sourceforge.net/NS/exist";
declare namespace request = "http://exist-db.org/xquery/request";
declare option exist:serialize "method=xml media-type=text/xml";

declare variable $legislation as document-node()* := collection('/db/cybar/edit');
declare variable $uuid as xs:string := request:get-parameter('uuid','');
declare variable $legis_id as xs:string := request:get-parameter('legislation','');
declare variable $after as xs:string := request:get-parameter('after','');
declare variable $before as xs:string := request:get-parameter('before','');
declare variable $amending_instrument as xs:string := request:get-parameter('amending_instrument','');
declare variable $enforce_date as xs:string :=request:get-parameter('enforce_date','');

(: Adding an appendix after another appendix :)
if ($after != "" and $before = "") then
    update insert <appendix id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><text id="tx{bytecrafts:generate-uuid-v4()}" current="yes"></text></appendix> following $legislation//legislation//appendix[@id=$after] 
(: Adding an appendix after another appendix :)
else if ($after = "" and $before != "") then
    update insert <appendix id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><text id="tx{bytecrafts:generate-uuid-v4()}" current="yes"></text></appendix> preceding $legislation//legislation//appendix[@id=$before]
(: Adding an appendix as the last element of a legis-body :)
else if ($after = "" and $before = "") then
    update insert <appendix id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><text id="tx{bytecrafts:generate-uuid-v4()}" current="yes"></text></appendix> into $legislation//legislation[@id=$legis_id]//legis-body
else ()