import module namespace bytecrafts = "http://www.bytecrafts.com" at "uuid.xql";

declare namespace exist = "http://exist.sourceforge.net/NS/exist";
declare namespace request = "http://exist-db.org/xquery/request";
declare option exist:serialize "method=xml media-type=text/xml";

declare variable $legislation as document-node()* := collection('/db/cybar/edit');
declare variable $uuid as xs:string := request:get-parameter('uuid','');
declare variable $legis_id as xs:string := request:get-parameter('legislation','');
declare variable $before as xs:string := request:get-parameter('before','');
declare variable $position_element as xs:string := request:get-parameter('position_element','');

(: Adding a preamble before another element :)
if ($before != "") then
        (: Adding a preamble before a section :)
        if ($position_element = "section")  then
            update insert <preamble id="{$uuid}" current="yes"></preamble> preceding $legislation//legislation[@id=$legis_id]//section[@id=$before]
        (: Adding a preamble before a division :)
        else if ($position_element = "division") then
            update insert <preamble id="{$uuid}" current="yes"></preamble> preceding $legislation//legislation[@id=$legis_id]//division[@id=$before]
        else()
(: Adding a preamble as the last element of a legis-body :)
else if ($before = "") then
         update insert <preamble id="{$uuid}" current="yes"></preamble> into $legislation//legislation[@id=$legis_id]/legis-body
else ()