import module namespace bytecrafts = "http://www.bytecrafts.com" at "uuid.xql";

declare namespace exist = "http://exist.sourceforge.net/NS/exist";
declare namespace request = "http://exist-db.org/xquery/request";
declare option exist:serialize "method=xml media-type=text/xml";

declare variable $uuid as xs:string := request:get-parameter('uuid','');
declare variable $parent_type as xs:string := request:get-parameter('parent_type','');
declare variable $parent_uuid as xs:string := request:get-parameter('parent_uuid','');
declare variable $after as xs:string := request:get-parameter('after','');
declare variable $before as xs:string := request:get-parameter('before','');
declare variable $position_element as xs:string := request:get-parameter('position_element','');
declare variable $legislation as document-node()* := collection("/db/cybar/edit");
declare variable $amending_instrument as xs:string := request:get-parameter('amending_instrument','');
declare variable $enforce_date as xs:string :=request:get-parameter('enforce_date','');

(: If we are adding a section to a division :)
if ($parent_type = "division") then
    (: Adding a section to a division after another element :)
    if ($after != "" and $before = "") then
        (: Adding a section to a division after another section :)
        if ($position_element = "section") then 
            update insert <section id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header><text id="tx{bytecrafts:generate-uuid-v4()}" current="yes"></text></section> following $legislation//section[@id=$after]
        (: Adding a section to a division it after a sub-division :)
        else if ($position_element = "sub-division") then
            update insert <section id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header><text id="tx{bytecrafts:generate-uuid-v4()}" current="yes"></text></section> following $legislation//sub-division[@id=$after]
        else()
    (: Adding a section to a division before another element :)
    else if ($after = "" and $before != "") then
        (: Adding a section to a division before another section :)
        if ($position_element = "section")  then
            update insert <section id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header><text id="tx{bytecrafts:generate-uuid-v4()}" current="yes"></text></section> preceding $legislation//section[@id=$before]
        (: Adding a section to a division before a sub-division :)
        else if ($position_element = "sub-division") then
            update insert <section id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header><text id="tx{bytecrafts:generate-uuid-v4()}" current="yes"></text></section> preceding $legislation//sub-division[@id=$before]     
        else()
    (: Adding a section as the last element of a division :)
    else if ($after = "" and $before = "") then
         update insert <section id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header><text id="tx{bytecrafts:generate-uuid-v4()}" current="yes"></text></section> into $legislation//division[@id=$parent_uuid]
    else ()
(: If we are adding section to a sub-division :)
else if ($parent_type = "sub-division") then
    (: Adding a section to a sub-division after another element :)
    if ($after != "" and $before = "") then
        (: Adding a section to a sub-division after another section :)
        if ($position_element = "section") then 
            update insert <section id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header><text id="tx{bytecrafts:generate-uuid-v4()}" current="yes"></text></section> following $legislation//section[@id=$after]
        (: Adding a section to a sub-division after a sub-sub-division :)
        else if ($position_element = "sub-sub-division") then
            update insert <section id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header><text id="tx{bytecrafts:generate-uuid-v4()}" current="yes"></text></section> following $legislation//sub-sub-division[@id=$after]
        else()
    (: Adding a section to a sub-division before another element :)
    else if ($after = "" and $before != "") then
        (: Adding a section to a sub-division before another section :)
        if ($position_element = "section")  then
            update insert <section id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header><text id="tx{bytecrafts:generate-uuid-v4()}" current="yes"></text></section> preceding $legislation//section[@id=$before]
        (: Adding a section to a sub-sub-division after another section :)
        else if ($position_element = "sub-sub-division") then
            update insert <section id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header><text id="tx{bytecrafts:generate-uuid-v4()}" current="yes"></text></section> preceding $legislation//sub-sub-division[@id=$before]     
        else()
    (: Adding a section as the last element of a sub-division :)
    else if ($after = "" and $before = "") then
         update insert <section id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header><text id="tx{bytecrafts:generate-uuid-v4()}" current="yes"></text></section> into $legislation//sub-division[@id=$parent_uuid]
    else ()
(: If we are adding section to a sub-sub-division :)    
else if ($parent_type = "sub-sub-division") then
    (: Adding a section to a sub-sub-division after another element :)
    if ($after != "" and $before = "") then
        (: Adding a section to a sub-sub-division after a section :)
        if ($position_element = "section") then 
            update insert <section id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header><text id="tx{bytecrafts:generate-uuid-v4()}" current="yes"></text></section> following $legislation//section[@id=$after]
        else()
    (: Adding a section to a sub-sub-division before another element :)
    else if ($after = "" and $before != "") then
        (: Adding a section to a sub-sub-division before a section :)
        if ($position_element = "section")  then
            update insert <section id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header><text id="tx{bytecrafts:generate-uuid-v4()}" current="yes"></text></section> preceding $legislation//section[@id=$before]
        else()
    (: Adding a section as the last element of a sub-sub-division :)
    else if ($after = "" and $before = "") then
         update insert <section id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header><text id="tx{bytecrafts:generate-uuid-v4()}" current="yes"></text></section> into $legislation//sub-sub-division[@id=$parent_uuid]
    else ()
(: If we are adding section to a legis-body :)
else if ($parent_type = "legis-body") then
    (: Adding a section to a legis-body after another element :)
    if ($after != "" and $before = "") then
        (: Adding a section to a legis-body after a section :)
        if ($position_element = "section") then 
            update insert <section id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header><text id="tx{bytecrafts:generate-uuid-v4()}" current="yes"></text></section> following $legislation//section[@id=$after]
        (: Adding a section to a legis-body after a division :)
        else if ($position_element = "division") then
            update insert <section id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header><text id="tx{bytecrafts:generate-uuid-v4()}" current="yes"></text></section> following $legislation//division[@id=$after]
        (: Adding a section to a legis-body after a preamble :)
        else if ($position_element = "preamble") then
            update insert <section id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header><text id="tx{bytecrafts:generate-uuid-v4()}" current="yes"></text></section> following $legislation//preamble[@id=$after]
        else()
    (: Adding a section to a legis-body before another element :)
    else if ($after = "" and $before != "") then
        (: Adding a section to a legis-body before a section :)
        if ($position_element = "section")  then
            update insert <section id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header><text id="tx{bytecrafts:generate-uuid-v4()}" current="yes"></text></section> preceding $legislation//section[@id=$before]
        (: Adding a section to a legis-body before a division :)
        else if ($position_element = "division") then
            update insert <section id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header><text id="tx{bytecrafts:generate-uuid-v4()}" current="yes"></text></section> preceding $legislation//division[@id=$before]     
        (: Adding a section to a legis-body before an appendix :)
        else if ($position_element = "appendix") then
            update insert <section id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header><text id="tx{bytecrafts:generate-uuid-v4()}" current="yes"></text></section> preceding $legislation//appendix[@id=$before]        
        else()
    (: Adding a section as the last element of a legis-body :)
    else if ($after = "" and $before = "") then
         update insert <section id="{$uuid}" current="yes" instrument-id="{$amending_instrument}" instrument-type="insertion" enforced-date="{$enforce_date}" dirty="yes"><enum id="en{bytecrafts:generate-uuid-v4()}" current="yes"></enum><header id="hr{bytecrafts:generate-uuid-v4()}" current="yes"></header><text id="tx{bytecrafts:generate-uuid-v4()}" current="yes"></text></section> into $legislation//legislation[@id=$parent_uuid]/legis-body
    else ()
else()