import module namespace functx = "http://www.functx.com" at "functx.xql";
import module namespace bytecrafts = "http://www.bytecrafts.com" at "uuid.xql";

declare namespace exist = "http://exist.sourceforge.net/NS/exist";
declare namespace request = "http://exist-db.org/xquery/request";
declare option exist:serialize "method=xml media-type=text/xml";

declare variable $uuid as xs:string := request:get-parameter('uuid','');
declare variable $parent_type as xs:string := request:get-parameter('parent_type','');
declare variable $legislation as document-node()* := collection("/db/cybar/edit");
declare variable $replaced as element()+ := $legislation//division[@id=$uuid];

update replace $legislation//division[@id=$uuid] with 
element division {
    for $attribute in functx:distinct-attribute-names($legislation//division[@id=$uuid]) return
        if ($attribute = 'id' and $replaced/@id != '') then
            attribute id {$replaced/@id}
        else if ($attribute = 'current' and $replaced/@current != '') then
            attribute current {$replaced/@current}
        else if ($attribute = 'instrument-id' and $replaced/@instrument-id != '') then
            attribute instrument-id {$replaced/division/@instrument-id}
        else if ($attribute = 'amended-id'and $replaced/@instrument-id != '') then
            attribute amended-id {$replaced/division/amended-id}
        else if ($attribute = 'instrument-type' and $replaced/@instrument-type != '') then
            attribute instrument-type {$replaced/division/instrument-type}
        else if ($attribute = 'enforced-date'and $replaced/@enforced-date != '') then
            attribute enforced-date {$replaced/division/enfored-date}
        else if ($attribute = 'expired-date' and $replaced/expired-date != '') then
            attribute expired-date {$replaced/division/expired-date}
        else(),
        functx:add-or-update-attributes($replaced/enum, xs:QName('id'), fn:concat('en', bytecrafts:generate-uuid-v4())),
        functx:add-or-update-attributes($replaced/header, xs:QName('id'), fn:concat('hr', bytecrafts:generate-uuid-v4())),
        let $count := count($replaced/*)
        for $i in 1 to $count return
            if (fn:node-name($replaced/*[$i]) = xs:QName('section')) then
                element section {
                    for $attribute1 in functx:distinct-attribute-names($replaced/*[$i]) return
                        if ($attribute1 ='id' and $replaced/*[$i]/@id != '') then
                            attribute id { fn:concat('sc',bytecrafts:generate-uuid-v4()) }
                        else if ($attribute1 = 'current' and $replaced/*[$i]/@current != '') then
                            attribute current {$replaced/*[$i]/@current}
                        else if ($attribute1 = 'instrument-id' and $replaced/*[$i]/@instrument-id != '') then
                            attribute instrument-id {$replaced/*[$i]/@instrument-id}
                        else if ($attribute1 = 'amended-id'and $replaced/*[$i]/amended-id != '') then
                            attribute amended-id {$replaced/*[$i]/amended-id}
                        else if ($attribute1 = 'instrument-type' and $replaced/*[$i]/@instrument-type != '' ) then
                            attribute instrument-type {$replaced/*[$i]/instrument-type}
                        else if ($attribute1 = 'enforced-date' and $replaced/*[$i]/@enforced-date != '') then
                            attribute enforced-date {$replaced/*[$i]/enfored-date}
                        else if ($attribute1 = 'expired-date' and $replaced/*[$i]/@expired-date != '') then
                            attribute expired-date {$replaced/*[$i]/expired-date}
                        else(),
                    for $elements in $replaced/*[$i]/* return
                        if (fn:node-name($elements) = xs:QName('enum')) then 
                            functx:add-or-update-attributes($elements, xs:QName('id'), fn:concat('en', bytecrafts:generate-uuid-v4()))
                        else if (fn:node-name($elements) = xs:QName('header')) then
                            functx:add-or-update-attributes($elements, xs:QName('id'), fn:concat('hr', bytecrafts:generate-uuid-v4()))
                        else if (fn:node-name($elements) = xs:QName('text')) then
                            functx:add-or-update-attributes($elements, xs:QName('id'), fn:concat('tx', bytecrafts:generate-uuid-v4()))
                        else()
                }
            else if (fn:node-name($replaced/*[$i]) = xs:QName('sub-division')) then
                element sub-division {
                    for $attribute2 in functx:distinct-attribute-names($replaced/*[$i]) return
                        if ($attribute2 ='id' and $replaced/*[$i]/@id != '') then
                            attribute id { fn:concat('sd',bytecrafts:generate-uuid-v4()) }
                        else if ($attribute2 = 'current' and $replaced/*[$i]/@current != '') then
                            attribute current {$replaced/*[$i]/@current}
                        else if ($attribute2 = 'instrument-id' and $replaced/*[$i]/@instrument-id != '') then
                            attribute instrument-id {$replaced/*[$i]/@instrument-id}
                        else if ($attribute2 = 'amended-id' and $replaced/*[$i]/@amended-id != '') then
                            attribute amended-id {$replaced/*[$i]/amended-id}
                        else if ($attribute2 = 'instrument-type' and $replaced/*[$i]/@instrument-type != '') then
                            attribute instrument-type {$replaced/*[$i]/instrument-type}
                        else if ($attribute2 = 'enforced-date' and $replaced/*[$i]/@enforced-date != '') then
                            attribute enforced-date {$replaced/*[$i]/enfored-date}
                        else if ($attribute2 = 'expired-date' and $replaced/*[$i]/@expired-date != '') then
                            attribute expired-date {$replaced/*[$i]/expired-date}
                        else(),
                    functx:add-or-update-attributes($replaced/*[$i]/header, xs:QName('id'), fn:concat('hr', bytecrafts:generate-uuid-v4())),
                    let $sub := $replaced/*[$i]
                    let $count1 := count($sub/*)
                    for $j in 1 to $count1 return
                        if (fn:node-name($sub/*[$j]) = xs:QName('section')) then
                            element section {
                                for $attribute3 in functx:distinct-attribute-names($sub/*[$j]) return
                                    if ($attribute3 ='id' and $sub/*[$j]/@id != '') then
                                        attribute id { fn:concat('sc',bytecrafts:generate-uuid-v4()) }
                                    else if ($attribute3 = 'current' and $sub/*[$j]/@current != '') then
                                        attribute current {$sub/*[$j]/@current}
                                    else if ($attribute3 = 'instrument-id' and $sub/*[$j]/@instrument-id != '') then
                                        attribute instrument-id {$sub/*[$j]/@instrument-id}
                                    else if ($attribute3 = 'amended-id' and $sub/*[$j]/@amended-id != '') then
                                        attribute amended-id {$sub/*[$j]/amended-id}
                                    else if ($attribute3 = 'instrument-type' and $sub/*[$j]/@instrument-type != '') then
                                        attribute instrument-type {$sub/*[$j]/instrument-type}
                                    else if ($attribute3 = 'enforced-date' and $sub/*[$j]/@enforced-date != '') then
                                        attribute enforced-date {$sub/*[$j]/enfored-date}
                                    else if ($attribute3 = 'expired-date' and $sub/*[$j]/@expired-date != '') then
                                        attribute expired-date {$sub/*[$j]/expired-date}
                                    else(),
                                    for $elements in $sub/*[$j]/* return
                                        if (fn:node-name($elements) = xs:QName('enum')) then 
                                            functx:add-or-update-attributes($elements, xs:QName('id'), fn:concat('en', bytecrafts:generate-uuid-v4()))
                                        else if (fn:node-name($elements) = xs:QName('header')) then
                                            functx:add-or-update-attributes($elements, xs:QName('id'), fn:concat('hr', bytecrafts:generate-uuid-v4()))
                                        else if (fn:node-name($elements) = xs:QName('text')) then
                                            functx:add-or-update-attributes($elements, xs:QName('id'), fn:concat('tx', bytecrafts:generate-uuid-v4()))
                                        else()    
                            }
                        else if (fn:node-name($sub/*[$j]) = xs:QName('sub-sub-division')) then
                            element sub-sub-division {
                                for $attribute4 in functx:distinct-attribute-names($sub/*[$j]) return
                                    if ($attribute4 ='id' and $sub/*[$j]/@id != '') then
                                        attribute id { fn:concat('sc',bytecrafts:generate-uuid-v4()) }
                                    else if ($attribute4 = 'current' and $sub/*[$j]/@current != '') then
                                        attribute current {$sub/*[$j]/@current}
                                    else if ($attribute4 = 'instrument-id' and $sub/*[$j]/@instrument-id != '') then
                                        attribute instrument-id {$sub/*[$j]/@instrument-id}
                                    else if ($attribute4 = 'amended-id' and $sub/*[$j]/@amended-id != '') then
                                        attribute amended-id {$sub/*[$j]/amended-id}
                                    else if ($attribute4 = 'instrument-type' and $sub/*[$j]/@instrument-type != '') then
                                        attribute instrument-type {$sub/*[$j]/instrument-type}
                                    else if ($attribute4 = 'enforced-date' and $sub/*[$j]/@enforced-date != '') then
                                        attribute enforced-date {$sub/*[$j]/enfored-date}
                                    else if ($attribute4 = 'expired-date' and $sub/*[$j]/@expired-date != '') then
                                        attribute expired-date {$sub/*[$j]/expired-date}
                                    else(),
                                functx:add-or-update-attributes($sub/*[$j]/header, xs:QName('id'), fn:concat('hr', bytecrafts:generate-uuid-v4())),
                                 let $subsub := $sub/*[$j]
                                 let $count2 := count($subsub/*)
                                 for $k in 1 to $count2 return
                                    if (fn:node-name($subsub/*[$k]) = xs:QName('section')) then
                                        element section {
                                            for $attribute5 in functx:distinct-attribute-names($subsub/*[$k]) return
                                                if ($attribute5 ='id' and $subsub/*[$k]/@id != '') then
                                                    attribute id { fn:concat('sc',bytecrafts:generate-uuid-v4()) }
                                                else if ($attribute5 = 'current' and $subsub/*[$k]/@current != '') then
                                                    attribute current {$subsub/*[$k]/@current}
                                                else if ($attribute5 = 'instrument-id' and $subsub/*[$k]/@instrument-id != '') then
                                                    attribute instrument-id {$subsub/*[$k]/@instrument-id}
                                                else if ($attribute5 = 'amended-id' and $subsub/*[$k]/@amended-id != '') then
                                                    attribute amended-id {$subsub/*[$k]/amended-id}
                                                else if ($attribute5 = 'instrument-type' and $subsub/*[$k]/@instrument-type != '') then
                                                    attribute instrument-type {$subsub/*[$k]/instrument-type}
                                                else if ($attribute5 = 'enforced-date' and $subsub/*[$k]/@enforced-date != '') then
                                                    attribute enforced-date {$subsub/*[$k]/enfored-date}
                                                else if ($attribute5 = 'expired-date' and $subsub/*[$k]/@expired-date != '') then
                                                    attribute expired-date {$subsub/*[$k]/expired-date}
                                                else(),
                                                for $elements in $subsub/*[$k]/* return
                                                    if (fn:node-name($elements) = xs:QName('enum')) then 
                                                        functx:add-or-update-attributes($elements, xs:QName('id'), fn:concat('en', bytecrafts:generate-uuid-v4()))
                                                    else if (fn:node-name($elements) = xs:QName('header')) then
                                                        functx:add-or-update-attributes($elements, xs:QName('id'), fn:concat('hr', bytecrafts:generate-uuid-v4()))
                                                    else if (fn:node-name($elements) = xs:QName('text')) then
                                                        functx:add-or-update-attributes($elements, xs:QName('id'), fn:concat('tx', bytecrafts:generate-uuid-v4()))
                                                    else()    
                                        }
                                    else()
                            }
                        else() 
                }
            else()
}