import module namespace xmldb = "http://exist-db.org/xquery/xmldb";

declare namespace exist = "http://exist.sourceforge.net/NS/exist";
declare namespace request = "http://exist-db.org/xquery/request";
declare option exist:serialize "method=xml media-type=text/xml";

declare variable $id as xs:string := request:get-parameter('uuid','');
declare variable $source as xs:string := request:get-parameter('source','');
declare variable $destination as xs:string := request:get-parameter('destination','');
declare variable $user as xs:string := request:get-parameter('user','');
declare variable $drafts as xs:string := fn:concat('/db/cybar/edit/draft/',$user);
declare variable $object as xs:string := fn:concat($id,".xml");
declare variable $stage as xs:string := request:get-parameter('stage','');
declare variable $type as xs:string := request:get-parameter('type','');
declare variable $comment as xs:string := request:get-parameter('comment','');
declare variable $legislation as document-node()* := collection('/db/cybar/edit');


if ($stage = '1' and xmldb:login('/db/cybar', 'cybar', 'cybar', false)) then 
    if ($source = 'legislation' and $destination ='drafts') then
        xmldb:copy('/db/cybar/legislation', $drafts, $object)
    else if ($source = 'drafts' and $destination = 'approval') then
        xmldb:move($drafts, '/db/cybar/edit/approval', $object)
    else if ($source = 'approval' and $destination = 'drafts') then
        xmldb:move('/db/cybar/edit/approval', $drafts, $object)
    else if ($source = 'approval' and $destination = 'legislation') then
        update delete $legislation//legislation[@id=$id]//metadata
    else()
else if ($stage = '2' and xmldb:login('/db/cybar', 'cybar', 'cybar', false)) then
    if ($source = 'legislation' and $destination = 'drafts') then
        update insert <metadata><user>{$user}</user><type>{$type}</type><location>drafts</location><comment>{$comment}</comment></metadata> preceding $legislation//legislation[@id=$id]/form
    else if ($source = 'approval' and $destination = 'drafts') then
        update replace $legislation//legislation[@id=$id]/metadata with <metadata><user>{$user}</user><type>{$type}</type><location>drafts</location><comment>{$comment}</comment></metadata>
    else if ($source = 'drafts' and $destination = 'approval') then
        update replace $legislation//legislation[@id=$id]/metadata with <metadata><user>{$user}</user><type>{$type}</type><location>approval</location><comment>{$comment}</comment></metadata>
    else if ($source = 'approval' and $destination = 'legislation') then
        xmldb:move('/db/cybar/edit/approval', '/db/cybar/legislation', $object)
    else()
else()