declare namespace exist = "http://exist.sourceforge.net/NS/exist";
declare namespace request = "http://exist-db.org/xquery/request";
declare option exist:serialize "method=xml media-type=text/xml";

declare variable $source as xs:string := request:get-parameter('source','');
declare variable $user as xs:string := request:get-parameter('user','');
declare variable $type as xs:string := request:get-parameter('type','');
declare variable $legislationapproval as document-node()* := collection('/db/cybar/edit/approval');
declare variable $legislationdraft as document-node()* := collection(fn:concat('/db/cybar/edit/draft/',$user));
declare variable $legislation as document-node()* := collection('/db/cybar/legislation');
declare variable $legislationdone as document-node()* := collection('/db/cybar/Done');

<results> {
if ($source = 'approval') then
for $law in $legislationapproval//legislation order by $law//short-title[1]/text() ascending return 
    element result {
        element uuid {data($law/@id)},
        element title {$law//short-title[1]/text()},
        element legisnum {$law//legis-num/text()},
        element user {$law//metadata/user/text()}
    }
else if ($source = 'drafts') then
for $law in $legislationdraft//legislation order by $law//short-title[1]/text() ascending return 
    element result {
        element uuid {data($law/@id)},
        element title {$law//short-title[1]/text()},
        element type {data($law/metadata/type/text())},
        element user {$law//metadata/user/text()}
    }
else if ($source = 'legislation') then
	if ($type = 'enop') then
		for $law in $legislation//legislation where $law//form/legis-type eq 'Ενοποιημένη Νομοθεσία'  order by $law//short-title[1]/text() ascending return 
    		element result {
        		element uuid {data($law/@id)},
        		element title {$law//short-title[1]/text()},
        		element legisnum {$law//legis-num/text()}
    		}
	else if ($type = 'kanon') then
		for $law in $legislation//legislation where $law//form/legis-type eq 'Διαδικαστικός Κανονισμός'  order by $law//short-title[1]/text() ascending return 
    		element result {
        		element uuid {data($law/@id)},
        		element title {$law//short-title[1]/text()},
        		element legisnum {$law//legis-num/text()}
    		}
	else if ($type = 'kdp') then
		for $law in $legislation//legislation where $law//form/legis-type eq 'Κανονιστική Διοικητική Πράξη' order by $law//short-title[1]/text() ascending return 
			element result {
        		element uuid {data($law/@id)},
        		element title {$law//short-title[1]/text()},
        		element legisnum {$law//legis-num/text()}
    		}
	else ()
else if ($source = 'done') then
for $law in $legislationdone//legislation where $law//form/legis-type eq 'Ενοποιημένη Νομοθεσία' order by $law//short-title[1]/text() ascending return 
    element result {
        element uuid {data($law/@id)},
        element title {$law//short-title[1]/text()},
        element type {data($law/metadata/type/text())},
        element user {$law//metadata/user/text()}
    }
else()
}
</results>