declare namespace exist = "http://exist.sourceforge.net/NS/exist";
declare namespace request = "http://exist-db.org/xquery/request";
declare option exist:serialize "method=xml media-type=text/xml";

declare variable $source as xs:string := request:get-parameter('source','');
declare variable $user as xs:string := request:get-parameter('user','');
declare variable $legislationapproval as document-node()* := collection('/db/cybar/edit/approval');
declare variable $legislationedit as document-node()* := collection('/db/cybar/edit');
declare variable $legislationdraft as document-node()* := collection(fn:concat('/db/cybar/edit/draft/',$user));
declare variable $legislation as document-node()* := collection('/db/cybar/legislation');

<results> {
if ($source = 'approval') then
for $law in $legislationapproval//legislation return
    element result {
        element uuid {data($law/@id)},
        element title {$law//short-title[1]/text()},
        element legisnum {$law//legis-num[1]/text()},
        element user {$law//metadata/user[1]/text()}
    }
else if ($source = 'edit') then
for $law in $legislationedit//legislation order by $law//short-title[1]/text() ascending return 
    element result {
        element uuid {data($law/@id)},
        element title {$law//short-title[1]/text()},
        element type {data($law/metadata/type/text())},
        element user {$law//metadata/user/text()}
    }
else if ($source = 'drafts') then
for $law in $legislationdraft//legislation order by $law//short-title[1]/text() ascending return 
    element result {
        element uuid {data($law/@id)},
        element title {$law//short-title[1]/text()},
        element type {data($law/metadata/type/text())},
        element user {$law//metadata/user/text()}
    }
else if ($source = 'legislation') then
for $law in $legislation//legislation order by $law//short-title[1]/text() ascending return 
    element result {
        element uuid {data($law/@id)},
        element title {$law//short-title[1]/text()},
        element legisnum {$law//legis-num/text()}
    }
else()
}
</results>