import module namespace functx = "http://www.functx.com" at "functx.xql";
import module namespace bytecrafts = "http://www.bytecrafts.com" at "uuid.xql";

declare namespace exist = "http://exist.sourceforge.net/NS/exist";
declare namespace request = "http://exist-db.org/xquery/request";
declare option exist:serialize "method=xml media-type=text/xml";

declare variable $uuid as xs:string := request:get-parameter('uuid','');
declare variable $parent_type as xs:string := request:get-parameter('parent_type','');
declare variable $legislation as document-node()* := collection("/db/cybar/edit");
declare variable $replaced as element()+ := $legislation//appendix[@id=$uuid];

update replace $legislation//appendix[@id=$uuid] with 
element appendix {
    for $attribute in functx:distinct-attribute-names($legislation//appendix[@id=$uuid]) return
        if ($attribute = 'id' and $replaced/@id != '') then
            attribute id {$replaced/@id}
        else if ($attribute = 'current' and $replaced/@current != '') then
            attribute current {$replaced/@current}
        else if ($attribute = 'instrument-id' and $replaced/@instrument-id != '') then
            attribute instrument-id {$replaced/@instrument-id}
        else if ($attribute = 'amended-id'and $replaced/@instrument-id != '') then
            attribute amended-id {$replaced/@amended-id}
        else if ($attribute = 'instrument-type' and $replaced/@instrument-type != '') then
            attribute instrument-type {$replaced/@instrument-type}
        else if ($attribute = 'enforced-date'and $replaced/@enforced-date != '') then
            attribute enforced-date {$replaced/@enfored-date}
        else if ($attribute = 'expired-date' and $replaced/@expired-date != '') then
            attribute expired-date {$replaced/@expired-date}
        else(),
        functx:add-or-update-attributes($replaced/enum, xs:QName('id'), fn:concat('en', bytecrafts:generate-uuid-v4())),
        let $count := count($replaced/*)
        for $i in 1 to $count return
            if (fn:node-name($replaced/*[$i]) = xs:QName('text')) then
                functx:add-or-update-attributes($replaced/text, xs:QName('id'), fn:concat('tx', bytecrafts:generate-uuid-v4()))
            else if (fn:node-name($replaced/*[$i]) = xs:QName('appendix-section')) then
                element appendix-section {
                    for $attribute in functx:distinct-attribute-names($legislation/*[$i]) return
                        if ($attribute = 'id' and $replaced/*[$i]/@id != '') then
                            attribute id { fn:concat('as',bytecrafts:generate-uuid-v4()) }
                        else if ($attribute = 'current' and $replaced/*[$i]/@current != '') then
                            attribute current {$replaced/*[$i]/@current}
                        else if ($attribute = 'instrument-id' and $replaced/*[$i]/@instrument-id != '') then
                            attribute instrument-id {$replaced/*[$i]/@instrument-id}
                        else if ($attribute = 'amended-id'and $replaced/*[$i]/@instrument-id != '') then
                            attribute amended-id {$replaced/*[$i]/@amended-id}
                        else if ($attribute = 'instrument-type' and $replaced/*[$i]/@instrument-type != '') then
                            attribute instrument-type {$replaced/*[$i]/@instrument-type}
                        else if ($attribute = 'enforced-date'and $replaced/*[$i]/@enforced-date != '') then
                            attribute enforced-date {$replaced/*[$i]/@enfored-date}
                        else if ($attribute = 'expired-date' and $replaced/*[$i]/@expired-date != '') then
                            attribute expired-date {$replaced/*[$i]/@expired-date}
                        else(),
                        functx:add-or-update-attributes($replaced/*[$i]/enum, xs:QName('id'), fn:concat('en', bytecrafts:generate-uuid-v4())),
                        functx:add-or-update-attributes($replaced/*[$i]/header, xs:QName('id'), fn:concat('hr', bytecrafts:generate-uuid-v4())),
                        functx:add-or-update-attributes($replaced/*[$i]/text, xs:QName('id'), fn:concat('tx', bytecrafts:generate-uuid-v4()))
                }
            else()    
}