import module namespace functx = "http://www.functx.com" at "functx.xql";
import module namespace bytecrafts = "http://www.bytecrafts.com" at "uuid.xql";

declare namespace exist = "http://exist.sourceforge.net/NS/exist";
declare namespace request = "http://exist-db.org/xquery/request";
declare option exist:serialize "method=xml media-type=text/xml";

declare variable $uuid as xs:string := request:get-parameter('uuid','');
declare variable $parent_type as xs:string := request:get-parameter('parent_type','');
declare variable $legislation as document-node()* := collection("/db/cybar/edit");
declare variable $replaced as element()+ := $legislation//section[@id=$uuid];

update replace $legislation//section[@id=$uuid] with 
element section {
    for $attribute in functx:distinct-attribute-names($legislation//section[@id=$uuid]) return
        if ($attribute = 'id' and $replaced/@id != '') then
            attribute id {$replaced/@id}
        else if ($attribute = 'current' and $replaced/@current != '') then
            attribute current {'no'}
        else if ($attribute = 'instrument-id' and $replaced/@instrument-id != '') then
            attribute instrument-id {$replaced/@instrument-id}
        else if ($attribute = 'amended-id'and $replaced/@instrument-id != '') then
            attribute amended-id {$replaced/@amended-id}
        else if ($attribute = 'instrument-type' and $replaced/@instrument-type != '') then
            attribute instrument-type {$replaced/@instrument-type}
        else if ($attribute = 'enforced-date'and $replaced/@enforced-date != '') then
            attribute enforced-date {$replaced/@enfored-date}
        else if ($attribute = 'expired-date' and $replaced/@expired-date != '') then
            attribute expired-date {$replaced/@expired-date}
        else(),
        functx:add-or-update-attributes($replaced/enum, (xs:QName('id'),xs:QName('current')), (fn:concat('en', bytecrafts:generate-uuid-v4()),'no')),
        functx:add-or-update-attributes($replaced/header, (xs:QName('id'),xs:QName('current')), (fn:concat('en', bytecrafts:generate-uuid-v4()),'no')),
        functx:add-or-update-attributes($replaced/text, (xs:QName('id'),xs:QName('current')), (fn:concat('en', bytecrafts:generate-uuid-v4()),'no'))
}